/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Instant;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.settings.StringSetting;
import meteordevelopment.meteorclient.systems.modules.Module;
import net.minecraft.class_2338;

public class CoordSnapper
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Boolean> chatfeedback;
    private final Setting<Boolean> webhook;
    private final Setting<String> webhookUrl;
    private final Setting<Boolean> selfPing;
    private final Setting<String> discordId;

    public CoordSnapper() {
        super(CatalystAddon.CATEGORY, "CoordSnapper", "Copies your coordinates to clipboard and optionally sends them via webhook.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.chatfeedback = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Chat Feedback")).description("Show notification in chat")).defaultValue((Object)true)).build());
        this.webhook = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("webhook")).description("Enable webhook notifications")).defaultValue((Object)false)).build());
        this.webhookUrl = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("webhook-url")).description("Discord webhook URL for notifications")).defaultValue((Object)"")).visible(() -> this.webhook.get())).build());
        this.selfPing = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("Self Ping")).description("Ping yourself in the webhook message")).defaultValue((Object)false)).visible(() -> this.webhook.get())).build());
        this.discordId = this.sgGeneral.add((Setting)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)((StringSetting.Builder)new StringSetting.Builder().name("Discord ID")).description("Your Discord user ID for pinging")).defaultValue((Object)"")).visible(() -> (Boolean)this.webhook.get() != false && (Boolean)this.selfPing.get() != false)).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivate() {
        try {
            if (this.mc.field_1724 == null) {
                this.error("Player is null!", new Object[0]);
                this.toggle();
                return;
            }
            class_2338 pos = this.mc.field_1724.method_24515();
            int x = pos.method_10263();
            int y = pos.method_10264();
            int z = pos.method_10260();
            String coords = String.format("%d %d %d", x, y, z);
            this.mc.field_1774.method_1455(coords);
            if (((Boolean)this.chatfeedback.get()).booleanValue()) {
                this.info("Copied coordinates: " + coords, new Object[0]);
            }
            if (((Boolean)this.webhook.get()).booleanValue() && !((String)this.webhookUrl.get()).isEmpty()) {
                this.sendWebhook(x, y, z);
            }
        }
        catch (Exception e) {
            this.error("Failed to copy/send coordinates: " + e.getMessage(), new Object[0]);
        }
        finally {
            this.toggle();
        }
    }

    private void sendWebhook(int x, int y, int z) {
        new Thread(() -> {
            try {
                URL url = new URL((String)this.webhookUrl.get());
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                JsonObject json = new JsonObject();
                json.addProperty("username", "Catalyst Webhook");
                json.addProperty("avatar_url", "https://i.imgur.com/OL2y1cr.png");
                String messageContent = "";
                if (((Boolean)this.selfPing.get()).booleanValue() && !((String)this.discordId.get()).trim().isEmpty()) {
                    messageContent = String.format("<@%s>", ((String)this.discordId.get()).trim());
                }
                json.addProperty("content", messageContent);
                JsonObject embed = new JsonObject();
                embed.addProperty("title", "Coordsnapper Coords");
                embed.addProperty("description", String.format("Coords: X: %d, Y: %d, Z: %d", x, y, z));
                embed.addProperty("color", (Number)7733503);
                embed.addProperty("timestamp", Instant.now().toString());
                JsonObject footer = new JsonObject();
                footer.addProperty("text", "Sent by Catalyst");
                embed.add("footer", (JsonElement)footer);
                JsonArray embeds = new JsonArray();
                embeds.add((JsonElement)embed);
                json.add("embeds", (JsonElement)embeds);
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = json.toString().getBytes("utf-8");
                    os.write(input, 0, input.length);
                }
                connection.getInputStream().close();
            }
            catch (Exception e) {
                this.error("Webhook failed: " + e.getMessage(), new Object[0]);
            }
        }).start();
    }
}

